var RNAStructure = function(){
	var sequences = {};
	var newSequences = {};
	var headerOfDescriptor = [];
	var comments = [];
	var rnaView = new RNAView();
	var UndoRedoIndex = -1;
	var UndoRedoArray = [];

	this.deleteStructure = function(){
		sequences = {};
		headerOfDescriptor = [];
		comments = [];
		UndoRedoIndex = -1;
		UndoRedoArray = [];
	}
	
	this.setHeaderOfDescriptor = function(newHeaderOfDescriptor){
		headerOfDescriptor = newHeaderOfDescriptor.split(' ');
	}
	
	this.getHeaderOfDescriptor = function(){
		return headerOfDescriptor;
	}
	
	this.getComments = function(){
		return comments;
	}
	
	this.getSequences = function(){
		return sequences;
	}

	this.AddComment = function(comment){
		comment = comment.slice(1, comment.length);
		comments.push(comment);
	}
	
	this.setComments = function(com){
		comments = com;
	}
	
	this.getSequence = function(sequence){
		return sequences[sequence];
	}
	
	this.setSequence = function(sequence){
		sequences[sequence.getName()] = sequence;
	}
	this.setColorInView = function(classTag, col, fCol){
		rnaView.setColorInView(classTag, col, fCol);
	}
	
	this.getImage = function(jpg){
		return rnaView.getImage(jpg);
	}
	
	this.renumberOrder = function(){
		if(headerOfDescriptor.length !== Object.keys(sequences).length){
			this.deleteStructure();
			showError("Error with header.");
			return;
		}
		var s = 1;
		var hr = 1;
		var newName1 = "";
		var newName2 = "";
		for(var i = 0; i < headerOfDescriptor.length; i++){
			var firstLetter = headerOfDescriptor[i][0];
			var lastLetter = headerOfDescriptor[i][headerOfDescriptor[i].length-1];
			if(firstLetter === "h" || firstLetter === "r"){
				if(lastLetter !== "'"){
					newName1 = firstLetter + hr;
					newName2 = firstLetter + hr + "'";
					var pairName = headerOfDescriptor[i] + "'";
					var ix = headerOfDescriptor.indexOf(pairName);
					headerOfDescriptor[ix] = newName2;
					var hrPair = sequences[pairName];
					if(typeof hrPair === "undefined"){
						this.deleteStructure();
						showError("Error with header.");
						return;
					}
					hrPair.setName(newName2);
					newSequences[newName2] = hrPair;
					hr++;		
				}
			}else if(firstLetter === "s"){
				newName1 = firstLetter + s;
				s++;		
			}else{
				this.deleteStructure();
				showError("Error with header.");
				return;	
			}
			if(firstLetter === "s" || lastLetter !== "'"){
				var shr = sequences[headerOfDescriptor[i]];
				if(typeof shr === "undefined"){
					this.deleteStructure();
					showError("Error with header.");
					return;
				}
				headerOfDescriptor[i] = newName1;
				shr.setName(newName1);
				newSequences[newName1] = shr;
			}
		}
		this.exchangeDictionaries();
	}
	
	this.addSequence = function(line){
		var param = line.split(/\s+/); // parameters
		if(checkParameters(param)){
			this.deleteStructure();
			showError("Error with line: " + line);
			return true;
		}
		var name = param[0]
		var insertionNumber = 0;
		var insertionLetter = "";
		var mistakes = param[1].split(':');
		var pattern = param[2].split(':');
		if(name[0]==='h'  || name[0]==='r'){
			if(mistakes.length === 3 && pattern.length === 3){
				insertionNumber = parseInt(mistakes[2]);
				insertionLetter = pattern[2];
			}
			var hr1 = new SequenceClass(name, mistakes[0], pattern[0]);
			var hr2 = new SequenceClass(name+"'", mistakes[1], pattern[1]);
			hr1.setPair(hr2);
			hr2.setPair(hr1);
			hr1.setInsertion(insertionNumber, insertionLetter);
			sequences[name] = hr1;
			sequences[name+"'"] = hr2;
			if(name[0]==='r'){
				hr1.setRule(param[3]);
				hr2.setRule(param[3]);
			}
		}else if(name[0]==='s'){
			if(mistakes.length === 2 && pattern.length === 2){
				insertionNumber = parseInt(mistakes[1]);
				insertionLetter = pattern[1];
			}
			var s = new SequenceClass(name, mistakes[0], pattern[0])
			s.setInsertion(insertionNumber, insertionLetter);
			sequences[name] = s;
		}
		return false;
	}
	
	function checkParameters(param){
		if(param.length < 3 || param.length > 4){
			console.log("==== 1");
			return true;
		}
		name = param[0];
		mistakes = param[1].split(":");
		pattern = param[2].split(":");
		if( ["r", "s", "h"].indexOf(name[0]) === -1 ){
			return true;
		}
		if(param.length === 4){
			rules = param[3];
			if(rules.length !== 4 || name[0] !== "r"){
				return true;
			}
		}
		if(name[0] === "r" || name[0] === "h"){
			if(mistakes.length !== pattern.length || 2 > mistakes.length || mistakes.length > 3){ 
				return true;
			}
			if(pattern[0].length !== pattern[1].length){
				return true;
			}
		}
		if(name[0] === "s"){
			if(mistakes.length !== pattern.length || 1 > mistakes.length || mistakes.length > 2){ 
				return true;
			}
		}
	}
	
	function showInEditor(){
		var order = headerOfDescriptor;
		var id = ""; 
		var insideTiptool = "";
		var whole_RNA = $("#whole-RNA");
		whole_RNA.empty();
		whole_RNA.append("<div class='dash selectable'> - </div>")		
		for(i=0; i<order.length; i++){
			if(order[i][order[i].length-1] === "'"){
				insideTiptool = order[i].slice(0, order[i].length-1) + "&rsquo;";
				id = order[i].slice(0, order[i].length-1) + "-";
			}
			else{
				insideTiptool = order[i];
				id = order[i];
			}						
			whole_RNA.append("<div id='"+ id +"' class='element' title='" + insideTiptool + "'>"
									+ sequences[order[i]].getPattern() +"</div>");
			$("#" + id).css("background-color", sequences[order[i]].getColor());
			$("#" + id).css("color", sequences[order[i]].getFontColor());
			$("#" + id).css( 'border-color', sequences[order[i]].getFontColor());
			whole_RNA.append("<div class='dash selectable'> - </div>")
		}
		rnaView.createNewGraph(headerOfDescriptor, sequences);
	}

	//      Add, remove -> single strand    ====================================================================
	
	this.addSingleStand = function(last, index, s){
		newSequences["s" + last] = s;
		shiftSequencesS("s", last, index);
		this.exchangeDictionaries();
	}
	
	function shiftSequencesS(letter, last, index){
		headerOfDescriptor.splice(index, 0, letter + last);
		for(var i = 0; i<headerOfDescriptor.length; i++){
			if(headerOfDescriptor[i][0] === "s" && i !== index && indexIsAfter(headerOfDescriptor[i], last)){
				var s = sequences[headerOfDescriptor[i]];
				var newName = solveNewName(headerOfDescriptor[i], 1); 
				headerOfDescriptor[i] = newName;
				s.setName(newName);
				newSequences[newName] = s;			
			}else if(i !== index){
				newSequences[headerOfDescriptor[i]] = sequences[headerOfDescriptor[i]];	
			}
		}
	}
	
	this.removeSequenceS = function(letter, order){
		var name = letter + order;
		var ix = headerOfDescriptor.indexOf(name);
		headerOfDescriptor.splice(ix, 1);
		for(var i = 0; i < headerOfDescriptor.length; i++){
			if(indexIsAfter(headerOfDescriptor[i], order) && headerOfDescriptor[i][0] === "s"){
				var hrs = sequences[headerOfDescriptor[i]];
				var newName = solveNewName(headerOfDescriptor[i], -1);
				headerOfDescriptor[i] = newName;
				hrs.setName(newName);
				newSequences[headerOfDescriptor[i]] = hrs;
			}else{
				newSequences[headerOfDescriptor[i]] = sequences[headerOfDescriptor[i]];
			}
		}	
		this.exchangeDictionaries();
	}	

	//     Add, remove -> helix, relation    =====================================================================
	
	this.addHelix = function(last, index1, index2, h1, h2){
		newSequences["h" + last] = h1;
		newSequences["h" + last + "'"] = h2;
		shiftSequencesHR("h", last, index1, index2);
		this.exchangeDictionaries();
	}
	
	this.addRelation = function(last, index1, index2, r1, r2){
		newSequences["r" + last] = r1;
		newSequences["r" + last + "'"] = r2;
		shiftSequencesHR("r", last, index1, index2);
		this.exchangeDictionaries();
	}

	function shiftSequencesHR(letter, last, index1, index2){
		headerOfDescriptor.splice(index2, 0, letter + last + "'");
		headerOfDescriptor.splice(index1, 0, letter + last);
		index2++;
		for(var i = 0; i<headerOfDescriptor.length; i++){
			if((headerOfDescriptor[i][0] === "h" || headerOfDescriptor[i][0] === "r") 
				   && i !== index1 && i !== index2 && indexIsAfter(headerOfDescriptor[i], last)){
				var hr = sequences[headerOfDescriptor[i]];
				var newName = solveNewName(headerOfDescriptor[i], 1); 
				headerOfDescriptor[i] = newName;
				hr.setName(newName);
				newSequences[newName] = hr;			
			}else if(i !== index1 && i !== index2){
				newSequences[headerOfDescriptor[i]] = sequences[headerOfDescriptor[i]];	
			}
		}
	}
	
	this.removeSequenceHR = function(letter, order){
		var name1 = letter + order;
		var name2 = letter + order + "'";
		var ix = headerOfDescriptor.indexOf(name1);
		headerOfDescriptor.splice(ix, 1);
		ix = headerOfDescriptor.indexOf(name2);
		headerOfDescriptor.splice(ix, 1);
		for(var i = 0; i < headerOfDescriptor.length; i++){
			if(indexIsAfter(headerOfDescriptor[i], order) 
				     && (headerOfDescriptor[i][0] === "h" || headerOfDescriptor[i][0] === "r")){
				var hrs = sequences[headerOfDescriptor[i]];
				var newName = solveNewName(headerOfDescriptor[i], -1);
				headerOfDescriptor[i] = newName;
				hrs.setName(newName);
				newSequences[headerOfDescriptor[i]] = hrs;
			}else{
				newSequences[headerOfDescriptor[i]] = sequences[headerOfDescriptor[i]];
			}
		}	
		this.exchangeDictionaries();
	}
	
	//    Help funcions ==============================================================================
	
	this.lastIndex = function(letter, i){
		i--;
		if(headerOfDescriptor.length === 0 || i < 0){
			return 1;
		}
		while(i>=0){
			var last = headerOfDescriptor[i];
			if(ceckLastName(letter, last)){
				return parseInt(last.substring(1, last.length)) + 1;
			}
			i--;
		}
		return 1;
	}
	
	function ceckLastName(letter, last){
		if(last[last.length-1] === "'"){
			return false;
		}
		if(letter === "h" || letter === "r"){
			if(last[0] === "h" || last[0] === "r"){
				return true;
			}
		}
		if(letter === "s" && last[0] === "s"){
			return true;
		}
		return false;
	}
	
	function indexIsAfter(name, last){
		name = name.replace("'", "");
		var index = name.slice(1, name.length);
		index = parseInt(index);
		if(index >= last){
			return true;
		}
		return false;
	}
	
	function solveNewName(name, plus){
		var rsquo = "";
		if(name.indexOf("'") !== -1){
			rsquo = "'";
		}
		name.replace("'", "");
		var index = name.slice(1, name.length);
		index = parseInt(index) + plus;
		var newName = name[0] + index + rsquo;
		return newName;
	}
	
	this.exchangeDictionaries = function(){
		UndoRedoIndex++;
		if(Object.keys(newSequences).length !== 0){
			sequences = newSequences;
			newSequences = {};
		}
		var header = headerOfDescriptor.slice(0, headerOfDescriptor.length);
		var _sequences = deepDictionaryCopy(sequences);
		var unit = [header, _sequences];
		UndoRedoArray = UndoRedoArray.slice(0, UndoRedoIndex);
		UndoRedoArray.push(unit);
		if(UndoRedoArray.length > 50){
			UndoRedoArray.shift();
			UndoRedoIndex--;
		}
		showInEditor();
	}
	
	function deepDictionaryCopy(seq){
		result = {};
		for(var key in seq){
			var oldSeq = seq[key];
			if((key[0] === "h" || key[0] === "r") && key[key.length-1] !== "'"){
				var newHR1 = new SequenceClass(oldSeq.getName(), oldSeq.getMistakes(), oldSeq.getPattern());
				newHR1.setColor(oldSeq.getColor());
				newHR1.setRule(oldSeq.getRule());
				var insertion = oldSeq.getInsertion();
				newHR1.setInsertion(insertion[0], insertion[1]);
				//===============================================
				var oldSeqPair = oldSeq.getPair();
				var newHR2 = new SequenceClass(oldSeqPair.getName(), oldSeqPair.getMistakes(), oldSeqPair.getPattern());
				newHR2.setColor(oldSeqPair.getColor());
				newHR2.setRule(oldSeqPair.getRule());
				var insertion = oldSeqPair.getInsertion();
				newHR2.setInsertion(insertion[0], insertion[1]);
				//================================================
				newHR1.setPair(newHR2);
				newHR2.setPair(newHR1);
				result[key] = newHR1;
				result[key + "'"] = newHR2;
			}else if(key[0] === "s"){
				var newSeq = new SequenceClass(oldSeq.getName(), oldSeq.getMistakes(), oldSeq.getPattern());
				newSeq.setColor(oldSeq.getColor());
				var insertion = oldSeq.getInsertion();
				newSeq.setInsertion(insertion[0], insertion[1]);
				result[key] = newSeq;	
			}
		}
		return result;
	}
	
	function showError(errorMessage){
		$("#error").text(errorMessage);
		$("#message").show();
		$("#message-error").show();
		$("#message-table").hide();
		$("#message-content").hide();
	}
	
	// Undo, Redo =========================================================================================
	
	this.undo = function(){
		if(UndoRedoIndex - 1 < 0){
			return;
		}
		UndoRedoIndex--;
		UnpackUnit();
	}
	
	this.redo = function(){
		if(UndoRedoIndex + 1 >= UndoRedoArray.length){
			return;
		}
		UndoRedoIndex++;
		UnpackUnit();
	}
	
	function UnpackUnit(){
		var unit = UndoRedoArray[UndoRedoIndex];
		headerOfDescriptor = unit[0].slice(0, unit[0].length);
		sequences = deepDictionaryCopy(unit[1]);
		showInEditor();
	}
}